#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;
void sumSubmatrices(const vector<vector<long long>>& matrix, int K, int L) {
    int rows = matrix.size(); 
    int cols = matrix[0].size();
    long long submatrixSum = 0;

    for (int i = 0; i <= rows - L; ++i) {
        for (int j = 0; j <= cols - K; ++j) {
            for (int x = i; x < i + L; ++x) {
                for (int y = j; y < j + K; ++y)  submatrixSum += matrix[x][y];
            }
        }
    }
    printf("%lld",submatrixSum);
}

void formSpiralMatrix(const vector<long long>& arr, int R, int C, vector<vector<long long>>& mat) {
    int top = 0, bottom = R - 1, left = 0, right = C - 1;
    int index = 0;

    while (1) {
        if (left > right)
            break;

        for (int i = left; i <= right; i++)
            mat[top][i] = arr[index++];
        top++;

        if (top > bottom)
            break;

        for (int i = top; i <= bottom; i++)
            mat[i][right] = arr[index++];
        right--;

        if (left > right)
            break;

        for (int i = right; i >= left; i--)
            mat[bottom][i] = arr[index++];
        bottom--;

        if (top > bottom)
            break;

        for (int i = bottom; i >= top; i--)
            mat[i][left] = arr[index++];
        left++;
    }
}

bool customSort(int a, int b) {
    return a < b;
}
void centerSpiralSort(vector<long long> &arr)
{
    int N=arr.size();
    int left = 0;
    int right = N - 1;
    int i = 1;
 
    while (left < right) {

        for (i = left + 1; i <= right;
             i++) {
            if (arr[left] > arr[i]) {
 
                swap(arr[left], arr[i]);
            }
        }
 
        left++;
 

        for (i = right - 1; i >= left;
             i--) {
            if (arr[right] > arr[i]) {
 
                swap(arr[right], arr[i]);
            }
        }
        right--;
    }
 
    if (N % 2 == 0) {

        for (int i = 0; i < N / 2; i++) {
            swap(arr[i], arr[N - 1 - i]);
        }
    }

}

int main() {
    
    int n,m; 
    scanf("%d", &n);
    scanf("%d", &m);
    int K, L;
    scanf("%d", &K);
    scanf("%d", &L);
    vector<long long> arr;
    
    for(int i=0; i<n*m;i++){
        long long tmp;cin>>tmp;
        arr.push_back(tmp);
    }
    sort(arr.begin(),arr.end());
    vector<long long> newarr;
    vector<long long> restarr;
    vector<long long> firstPartArr;
    
    if(n==m){
        newarr=arr;
    }else{
        if(n>m){
            if(m%2==1){
                for(int i=0; i<arr.size()-(n-(m-1)); i++)firstPartArr.push_back(arr[i]);
                for(int i=arr.size()-(n-(m-1)); i<arr.size();i++)restarr.push_back(arr[i]);
                
                //centerSpiralSort(restarr);
                newarr.reserve(arr.size());
                newarr.insert(newarr.end(),firstPartArr.begin(), firstPartArr.end());
                newarr.insert(newarr.end(),restarr.begin(), restarr.end());
            }else{
                for(int i=0; i<arr.size()-2*(n-(m-2));i++)firstPartArr.push_back(arr[i]);
                for(int i=arr.size()-2*(n-(m-2)); i<arr.size();i++)restarr.push_back(arr[i]);
              
                vector<long long> tmp1;
                vector<long long> tmp2;
                for(int i=0; i<restarr.size();i=i+2){
                    tmp1.push_back(restarr[i]);
                    tmp2.push_back(restarr[i+1]);
                }

                //centerSpiralSort(tmp1);
                
               // centerSpiralSort(tmp2);
                
                newarr.reserve(arr.size());
                newarr.insert(newarr.end(),firstPartArr.begin(), firstPartArr.end());
                newarr.insert(newarr.end(),tmp1.begin(), tmp1.end());
                newarr.insert(newarr.end(),tmp2.begin(), tmp2.end());
            }
        }else{
            if(n%2==1){
                for(int i=0; i<arr.size()-(m-(n-1)); i++)firstPartArr.push_back(arr[i]);
                for(int i=arr.size()-(m-(n-1)); i<arr.size();i++)restarr.push_back(arr[i]);

                centerSpiralSort(restarr);
                newarr.reserve(arr.size());
                newarr.insert(newarr.end(),firstPartArr.begin(), firstPartArr.end());
                newarr.insert(newarr.end(),restarr.begin(), restarr.end());
            }else{
                for(int i=0; i<arr.size()-2*(m-(n-2));i++)firstPartArr.push_back(arr[i]);
                for(int i=arr.size()-2*(m-(n-2)); i<arr.size();i++)restarr.push_back(arr[i]);
                vector<long long> tmp1;
                vector<long long> tmp2;
                for(int i=0; i<restarr.size();i=i+2){
                    tmp1.push_back(restarr[i]);
                    tmp2.push_back(restarr[i+1]);
                }
                 
                centerSpiralSort(tmp1);
                
                centerSpiralSort(tmp2);
                newarr.reserve(arr.size());
                newarr.insert(newarr.end(),firstPartArr.begin(), firstPartArr.end());
                newarr.insert(newarr.end(),tmp1.begin(), tmp1.end());
                newarr.insert(newarr.end(),tmp2.begin(), tmp2.end());
            }
        }
    }
    
    
    
    vector<vector<long long>> mat(n, vector<long long>(m));

    formSpiralMatrix(newarr, n, m, mat);
    sumSubmatrices(mat, K, L);

    return 0;

}